// Change the SECRET_PHRASE variable to be a lab-appropriate word or phrase of
// your choosing, and change FREQUENCY to be your chosen modulation frequency.
// This program will repeatedly transmit SECRET_PHRASE.
//
// You probably want to keep the \n on the front of SECRET_PHRASE to make the
// output a little easier to read (without it, you won't have a blank line
// between repetitions of the phrase).
const char SECRET_PHRASE[] = "\n(^_^) yay 6.200";
const float FREQUENCY = 1;  // frequency in Hz


// probably no need to change anything below this point, but feel free to read
// on if you want.
const int WORD_LENGTH = sizeof(SECRET_PHRASE) / sizeof(char); // number of characters in the message
const int NUM_BITS = WORD_LENGTH * 7; // number of bits in the message
const unsigned int BIT_PERIOD = 100000; // microseconds;
const double TAU = 2 * 3.141592;

void setup() {
  // initialize pin 14 as our output pin
  analogWriteFrequency(14, 1000000);
  pinMode(14, OUTPUT);
}

unsigned int bit_index = 0;

void loop() {
  unsigned long now = micros();
  unsigned int bit_index = (now / BIT_PERIOD) % (NUM_BITS+7);

  if (bit_index < 7){
    // wait for a full character's worth of time with the signal
    // "off" to signal the end of the message of interest before
    // sending the next repetition
    analogWrite(14, 128);
  }else{
    // based on the current eim, which character are we currently sending, and
    // which bit within that character are we currently sending?
    int which_char = bit_index / 7 - 1;
    int which_bit = bit_index % 7;

     // figure out whether this bit is a 1 or a 0
    int this_bit = (SECRET_PHRASE[which_char] & (1 << (6-which_bit))) >> (6-which_bit);

    // turn on the sine wave for 1/4 of the bit period to signal a 0
    // turn on the sine wave for 3/4 of the bit period to signal a 1
    // the receiver is expecting these timings/lengths
    float where_in_bit = (float)(now % BIT_PERIOD) / BIT_PERIOD;
    float val = 0.5 + 0.5 * sin(FREQUENCY * TAU * now / 1E6) * (where_in_bit < (this_bit ? 0.25: 0.75));
    analogWrite(14, (int)(val*255));
  }
}
